/****** Object:  StoredProcedure [dbo].[P_PDV_VD_CHQS_APLICAR_CHQS_TIPO]    Script Date: 11/28/2013 09:36:38 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_PDV_VD_CHQS_APLICAR_CHQS_TIPO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_PDV_VD_CHQS_APLICAR_CHQS_TIPO]
GO
GO
--EXEC P_PDV_VD_CHQS_APLICAR_CHQS_TIPO 1,11,'2018-01-01','2019-12-31'
CREATE PROCEDURE P_PDV_VD_CHQS_APLICAR_CHQS_TIPO @CD_EMP INT, @CD_FILIAL INT, @DT_INI DATETIME, @DT_FIM DATETIME
AS
SET NOCOUNT ON
DECLARE @VLR_CHQS_VISTA MONEY
DECLARE @VLR_CHQS_PRAZO MONEY
DECLARE @CD_VD INT

DECLARE ProcCheques CURSOR FAST_FORWARD FOR 
SELECT
	CD_VD,
	SUM(CASE WHEN DT_VENCTO <> DT_EMI THEN
		VL_CHQ
	ELSE
		0
	END) AS VL_CHQ_PRZ,
	SUM(CASE WHEN DT_VENCTO <> DT_EMI THEN
		0
	ELSE
		VL_CHQ
	END) AS VL_CHQ_VISTA
	FROM
	PDV_VD_CHQS
WHERE
	CD_EMP =@CD_EMP
	AND CD_FILIAL =@CD_FILIAL
	AND DT_EMI BETWEEN @DT_INI AND @DT_FIM
GROUP BY
	CD_VD


OPEN ProcCheques;
FETCH NEXT FROM ProcCheques INTO @CD_VD, @VLR_CHQS_PRAZO,@VLR_CHQS_VISTA;
WHILE @@FETCH_STATUS = 0
    BEGIN
		PRINT CONVERT(VARCHAR(10),@CD_VD)
		UPDATE
			PDV_VD
		SET 
			PDV_VD.VL_CHQS_A_VISTA=@VLR_CHQS_VISTA,
			PDV_VD.VL_CHQS_A_PRZ=@VLR_CHQS_PRAZO
		FROM
			PDV_VD 
		WHERE
			CD_EMP =@CD_EMP
			AND CD_FILIAL=@CD_FILIAL
			AND CD_VD = @CD_VD

		FETCH NEXT FROM ProcCheques INTO @CD_VD, @VLR_CHQS_PRAZO,@VLR_CHQS_VISTA;
    END;
PRINT 'CONCLUIDO.';
CLOSE ProcCheques;
DEALLOCATE ProcCheques;


